﻿<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>Podsumowanie akordów</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat="server">

            FromTo okres = FromTo.Empty;
            [Context(typeof(OkresContext), "Okres", Required=false)]
            public FromTo Okres {
                get { return okres; }
                set { okres = value; }
            }
			
			class Item: IComparable {
				public int CompareTo(object v) {
					if (v==null)
						return 1;
					Item item = v as Item;
					if (item==null)
						throw new ArgumentException("Zły typ parametru", "c");
					return Definicja.Nazwa.CompareTo(item.Definicja.Nazwa);
				}
			
				readonly DefinicjaAkordu definicja;
				Time czas = Time.Zero;
				double ilość = 0.0;
				decimal wartość = 0m;
				public Item(DefinicjaAkordu definicja) {
					this.definicja = definicja;
				}
				public void Add(Akord.InfoWorker info) {
					czas += info.Czas;
					ilość += info.Ilość;
					wartość += info.Wartość;
				}				
				public DefinicjaAkordu Definicja {
					get { return definicja; }
				}
				public Time Czas {
					get { return czas; }
				}
				public double Ilość {
					get { return ilość; }
				}
				public decimal Wartość {
					get { return wartość; }
				}
			}
			
			Akord.InfoWorker info = new Akord.InfoWorker();
			Hashtable akordy = new Hashtable();
			
			void OnContextLoad(object sender, EventArgs e) {
                report = ReportHeader;
                Row[] rows = (Row[])dc[typeof(Row[])];
                ArrayList lista = new ArrayList();
                int rowLp = 1;

                foreach (Pracownik idx in rows) {
                    bool any = false;
                    decimal razem = 0m;
                    Time czas = Time.Zero;
                 
                    foreach (Akord akord in idx.Akordy) {
                        try {
                            if ((akord.Okres * okres) == FromTo.Empty)
                                continue;

                            string[] kolumny = new string[8];

                            info.Akord = akord;
                            info.Okres = okres;

                            AkordHistoria ah = akord[okres.To];
                            kolumny[0] = (rowLp++).ToString();
                            kolumny[1] = idx.ToString();
                            kolumny[2] = akord.Definicja.Nazwa;
                            kolumny[3] = ah.Jednostka;

                            if (info.Czas == Time.Zero)
                                kolumny[4] = "&nbsp;";
                            else
                                kolumny[4] = info.Czas.ToString();

                            if (info.Ilość == 0)
                                kolumny[5] = "&nbsp;";
                            else
                                kolumny[5] = info.Ilość.ToString();

                            if (akord is AkordGrupowy || ah.Algorytm.Progresywny)
                                kolumny[6] = "&nbsp;";
                            else
                                kolumny[6] = ah.Algorytm.Wartosc.ToString();

                            if (info.Wartość == 0m)
                                kolumny[7] = "&nbsp;";
                            else
                                kolumny[7] = info.Wartość.ToString();
                        
                            czas += info.Czas;
                            razem += info.Wartość;
                            any = true;

                            lista.Add(kolumny);

                            Item item = (Item)akordy[akord.Definicja];
                            if (item == null)
                                akordy.Add(akord.Definicja, item = new Item(akord.Definicja));
                            item.Add(info);
                        }
                        catch { Msg(); }
                    }

                    if (any) {
                        string[] kolumny = new string[8];

                        kolumny[0] = "&nbsp;";
                        kolumny[1] = "&nbsp;";
                        kolumny[2] = "<strong>Suma:</strong>";
                        kolumny[3] = "&nbsp;";
                        kolumny[4] = "<strong>" + czas.ToString() + "</strong>";
                        kolumny[5] = "&nbsp;";
                        kolumny[6] = "&nbsp;";
                        kolumny[7] = "<strong>" + razem.ToString("n") + "</strong>";

                        lista.Add(kolumny);
                    }
                }
                            
                Grid.DataSource = lista;

                ArrayList lista1 = new ArrayList(akordy.Values);
                lista1.Sort();
                Grid1.DataSource = lista1;
            }
			
			void OnBeforeRow(object sender, RowEventArgs e) {
                string[] kolumny = (string[])e.Row;

                colLP.AddLine(kolumny[0]);
                colPracownik.AddLine(kolumny[1]);
                colNazwa.AddLine(kolumny[2]);
                colJednostka.AddLine(kolumny[3]);
                colCzas.AddLine(kolumny[4]);
                colIlosc.AddLine(kolumny[5]);
                colStawka.AddLine(kolumny[6]);
                colWartosc.AddLine(kolumny[7]);
			}

            public static ReportHeader report;

            public static void Msg() {
                string msg = "Wydruk przygotowany na podstawie danych, do których operator ma prawa dostępu";
                if (report != null && !report.Title.Contains(msg))
                    report.Title += "|" + msg;
            }
			
		</script>
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad"></ea:datacontext><eb:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" title="Podsumowanie wykonania akordów|</strong>Wydział: <strong>{0}</strong>, pośrednio: <strong>{1}|</strong>Raport za okres: <strong>{2}"
				runat="server" DataMember3="KadryPracownicyViewInfo+PrParams.Aktualny" DataMember2="KadryPracownicyViewInfo+PrParams.Okres" DataMember1="KadryPracownicyViewInfo+PrParams.Pośrednio"
				DataMember0="KadryPracownicyViewInfo+PrParams.Wydział"></eb:reportheader>
			<P><ea:grid id="Grid" runat="server" onbeforerow="OnBeforeRow">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" Caption="LP." ID="colLP"></ea:GridColumn>
						<ea:GridColumn Align="Left" Caption="Nazwisko i imię" ID="colPracownik"></ea:GridColumn>
						<ea:GridColumn Width="20" Caption="Nazwa" ID="colNazwa"></ea:GridColumn>
						<ea:GridColumn Width="12" Align="Right" Caption="Czas" ID="colCzas"></ea:GridColumn>
						<ea:GridColumn Width="12" Align="Right" Caption="Ilość" ID="colIlosc"></ea:GridColumn>
						<ea:GridColumn Width="5" Align="Center" Caption="jm" ID="colJednostka"></ea:GridColumn>
						<ea:GridColumn Width="12" Align="Right" Caption="Stawka" Format="{0:n}" ID="colStawka"></ea:GridColumn>
						<ea:GridColumn Width="12" Align="Right" Caption="Wartość" Format="{0:n}" ID="colWartosc"></ea:GridColumn>
					</Columns>
				</ea:grid></P>
			<P>
				<strong>Zestawienie wg rodzajów akordów</strong><br>
				<ea:grid id="Grid1" runat="server">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
						<ea:GridColumn DataMember="Definicja.Nazwa" Total="Info" Caption="Nazwa"></ea:GridColumn>
						<ea:GridColumn Width="12" Align="Right" DataMember="Czas" Total="Sum" Caption="Czas"></ea:GridColumn>
						<ea:GridColumn Width="12" Align="Right" DataMember="Ilość" Caption="Ilość"></ea:GridColumn>
						<ea:GridColumn Width="5" Align="Center" DataMember="Definicja.Jednostka" Caption="jm"></ea:GridColumn>
						<ea:GridColumn Width="12" Align="Right" Caption="Stawka" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="12" Align="Right" DataMember="Wartość" Total="Sum" Caption="Wartość" Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:grid><eb:reportfooter id="ReportFooter" runat="server" TheEnd="False"></eb:reportfooter>
			</P>
		</FORM>
	</BODY>
</HTML>

